package edu.uky.ai.rl.ex;

import java.util.Random;

import edu.uky.ai.rl.Action;
import edu.uky.ai.rl.Policy;
import edu.uky.ai.rl.State;
import edu.uky.ai.util.ImmutableArray;

/**
 * Chooses an action at random.
 * 
 * @author Your Name
 */
public class RandomPolicy implements Policy {
	
	/** Used when serializing and deserializing the policy object */
	private static final long serialVersionUID = 1L;
	
	/** The list of all possible actions */
	private final ImmutableArray<Action> actions;
	
	/** A random number generator */
	private final Random random = new Random(0);
	
	/**
	 * Constructs a new random policy.
	 * 
	 * @param actions the list of all possible actions
	 */
	public RandomPolicy(ImmutableArray<Action> actions) {
		this.actions = actions;
	}

	@Override
	public Action choose(State state) {
		return actions.get(random.nextInt(actions.size()));
	}
}
